#include <allegro.h>

#include "actor.h"
#include "draw.h"
#include "sectors.h"
#include "man.h"
#include "alienship.h"
#include "fir.h"

float fir0_points[] = {
	   -15.781,     -6.312, // 0
	     6.312,    290.373, // 1
	   -27.510,    240.088, // 2
	    34.719,    249.342, // 3
	    -9.469,    246.186, // 4
	    15.781,    246.186, // 5
	   -53.656,    189.374, // 6
	    59.968,    189.374, // 7
	    34.719,    173.593, // 8
	   -18.937,    186.218, // 9
	   -85.218,    107.312, // 10
	   -50.500,    104.156, // 11
	  -113.624,     31.562, // 12
	   -15.781,     25.250, // 13
	    12.625,      6.312, // 14
	     9.469,     22.094, // 15
	   107.312,     37.875, // 16
	    63.125,     94.687, // 17
	    82.062,    107.312, // 18
	     3.156,     91.531, // 19
	   -31.562,    119.937, // 20
	    37.875,    113.624, // 21
	   -18.937,    205.155, // 22
	     6.312,    183.061, // 23
	    25.250,    205.155  // 24
};
int fir0_lines[] = {
	1, 2, 0, 124, 0,
	4, 6, 0, 124, 0,
	6, 9, 0, 124, 0,
	10, 11, 0, 124, 0,
	12, 13, 0, 124, 0,
	15, 16, 0, 124, 0,
	17, 18, 0, 124, 0,
	8, 7, 0, 124, 0,
	5, 3, 0, 124, 0,
	1, 3, 0, 160, 0,
	9, 10, 0, 160, 0,
	11, 12, 0, 160, 0,
	17, 16, 0, 160, 0,
	8, 18, 0, 160, 0,
	5, 7, 0, 160, 0,
	13, 0, 176, 104, 0,
	15, 14, 176, 104, 0,
	20, 19, 56, 220, 0,
	19, 21, 56, 220, 0,
	24, 23, 56, 220, 0,
	23, 22, 56, 220, 0,
	2, 4, 56, 220, 0 
};
float fir1_points[] = {
	   -14.424,      8.991, // 0
	   237.869,    166.658, // 1
	   187.569,    182.567, // 2
	   221.586,    119.484, // 3
	   195.072,    150.055, // 4
	   207.840,    132.887, // 5
	   132.549,    170.063, // 6
	   188.167,     63.655, // 7
	   160.507,     74.681, // 8
	   138.951,    125.412, // 9
	    30.011,    125.046, // 10
	    54.114,    102.324, // 11
	   -50.018,    115.042, // 12
	    11.026,     27.659, // 13
	    12.557,     -6.446, // 14
	    23.415,      5.433, // 15
	   150.055,      0.000, // 16
	   117.543,     37.514, // 17
	   157.558,     17.506, // 18
	    80.029,     40.015, // 19
	    78.040,     96.389, // 20
	   117.543,     72.527, // 21
	   154.221,    136.613, // 22
	   151.341,    103.186, // 23
	   180.356,    100.984  // 24
};
int fir1_lines[] = {
	1, 2, 0, 124, 0,
	4, 6, 0, 124, 0,
	6, 9, 0, 124, 0,
	10, 11, 0, 124, 0,
	12, 13, 0, 124, 0,
	15, 16, 0, 124, 0,
	17, 18, 0, 124, 0,
	8, 7, 0, 124, 0,
	5, 3, 0, 124, 0,
	1, 3, 0, 160, 0,
	9, 10, 0, 160, 0,
	11, 12, 0, 160, 0,
	17, 16, 0, 160, 0,
	8, 18, 0, 160, 0,
	5, 7, 0, 160, 0,
	13, 0, 176, 104, 0,
	15, 14, 176, 104, 0,
	20, 19, 56, 220, 0,
	19, 21, 56, 220, 0,
	24, 23, 56, 220, 0,
	23, 22, 56, 220, 0,
	4, 2, 56, 220, 0 
};
float fir2_points[] = {
	    -5.002,      0.000, // 0
	   275.101,     10.004, // 1
	   260.096,     60.022, // 2
	   227.584,      7.503, // 3
	   260.096,     35.013, // 4
	   250.092,     22.508, // 5
	   147.554,     77.529, // 6
	   185.068,     -2.501, // 7
	   142.552,     10.004, // 8
	   177.565,     45.017, // 9
	    50.018,     77.529, // 10
	    85.031,     37.514, // 11
	   -27.510,     65.024, // 12
	    21.115,     20.995, // 13
	     5.002,     -2.501, // 14
	    23.645,     -4.326, // 15
	   110.040,     -7.503, // 16
	    82.530,      7.503, // 17
	   142.552,     -2.501, // 18
	    89.946,     17.250, // 19
	   109.932,     57.410, // 20
	   125.046,     37.514, // 21
	   207.576,     50.018, // 22
	   190.070,     17.506, // 23
	   205.639,     20.942  // 24
};
int fir2_lines[] = {
	1, 2, 0, 124, 0,
	4, 6, 0, 124, 0,
	6, 9, 0, 124, 0,
	10, 11, 0, 124, 0,
	12, 13, 0, 124, 0,
	15, 16, 0, 124, 0,
	17, 18, 0, 124, 0,
	8, 7, 0, 124, 0,
	5, 3, 0, 124, 0,
	1, 3, 0, 160, 0,
	9, 10, 0, 160, 0,
	11, 12, 0, 160, 0,
	17, 16, 0, 160, 0,
	8, 18, 0, 160, 0,
	5, 7, 0, 160, 0,
	13, 0, 176, 104, 0,
	15, 14, 176, 104, 0,
	20, 19, 56, 220, 0,
	19, 21, 56, 220, 0,
	24, 23, 56, 220, 0,
	23, 22, 56, 220, 0,
	4, 2, 56, 220, 0 
};

void fir_process(int num)
{
	int remove = 0;
	ACTOR *actor = man[num];
	
	{
		float d = actor->x - alienship.x;
		if (d > SECTORS * SECTOR_DIMENSION / 2) {
			d -= SECTORS * SECTOR_DIMENSION;
		}
		if (d < -SECTORS * SECTOR_DIMENSION / 2) {
			d += SECTORS * SECTOR_DIMENSION;
		}
		if ( d > 3000 || d < -3000) {
			if (sector_place_man(actor)) remove = 1;
		}
	}
	
	if (actor->hit) {
		actor->anim++;
		if (actor->anim == 16) {
			actor->anim = 0;
			actor->frame++;
			if (actor->frame == 4) actor->frame = 3;
		}
	}
	
	if (remove) {
		mans_num--;
		if (mans_num > 0) {
			man[num] = man[mans_num];
			man_process(num);
		}
	}
}

static void fir_draw(ACTOR *actor, int x, int y)
{
	if (actor->dx > 0) {
		if (actor->frame == 0) draw_(x, y, points(fir0), lines(fir0), fir0_points, fir0_points, fir0_lines, actor->anim / 16.0);
		if (actor->frame == 1) draw_(x, y, points(fir0), lines(fir0), fir0_points, fir1_points, fir0_lines, actor->anim / 16.0);
		if (actor->frame == 2) draw_(x, y, points(fir1), lines(fir1), fir1_points, fir2_points, fir1_lines, actor->anim / 16.0);
		if (actor->frame == 3) draw_(x, y, points(fir2), lines(fir2), fir2_points, fir2_points, fir2_lines, actor->anim / 16.0);		
	}
	if (actor->dx < 0) {
		if (actor->frame == 0) m_draw_(x, y, points(fir0), lines(fir0), fir0_points, fir0_points, fir0_lines, actor->anim / 16.0);
		if (actor->frame == 1) m_draw_(x, y, points(fir0), lines(fir0), fir0_points, fir1_points, fir0_lines, actor->anim / 16.0);
		if (actor->frame == 2) m_draw_(x, y, points(fir1), lines(fir1), fir1_points, fir2_points, fir1_lines, actor->anim / 16.0);
		if (actor->frame == 3) m_draw_(x, y, points(fir2), lines(fir2), fir2_points, fir2_points, fir2_lines, actor->anim / 16.0);		
	}
}

ACTOR *fir_init(void)
{
	static int gotcolor = 0;
	ACTOR *actor;
	if (mans_total == TOTAL_MANS) return NULL;
	actor = &(all_mans[mans_total]);
	actor_init(actor);
	bound_(points(fir0), fir0_points, &actor->l, &actor->t, &actor->r, &actor->b);
	if (!gotcolor) {
		color_(lines(fir0), fir0_lines);
		color_(lines(fir1), fir1_lines);
		color_(lines(fir2), fir2_lines);
		gotcolor = 1;
	}
	actor->draw = fir_draw;
	
	if ((rand() >> 8) & 1) actor->dx = 1; else {
		float t = actor->l;
		actor->dx = -1;
		actor->l = -actor->r;
		actor->r = -t;
	}
	
	actor->type = FIR;
	
	mans_total++;
	return actor;
}
